
////////////
// Topic  //
////////////
// A Topic object is simply a structure that
// holds section, topic and subtopic.
function Topic(s, t, st)
{
	if (st == "" || st == null)
	{
		st = 0;
	}
	else if (typeof st != "number")
	{
		st = getSubtopicHelper(st) + 1;
	}
	this.section = s;
	this.topic = t;
	this.subtopic = st;
	
	this.toString = TopicToString;
	this.compare = TopicCompare;
	this.type = "Topic";
}

function TopicCompare(t)
{
	return (this.toString() == t.toString());
}

function TopicToString()
{
	var temp = this.section + "," + this.topic + "," + this.subtopic;
	return temp;
}

///////////
// Page  //
///////////
// A Page object is simply a structure that
// holds section, topic, subtopic and page.
function Page(s, t, st, p)
{
	if (st == "" || st == null)
	{
		st = 0;
	}
	else if (typeof st != "number")
	{
		st = getSubtopicHelper(st) + 1;
	}
	this.section = s;
	this.topic = t;
	this.subtopic = st;
	this.page = p;
	
	this.toString = PageToString;
	this.compare = PageCompare;
	this.type = "Page";
}

function PageCompare(pg)
{
	return (this.toString() == pg.toString());
}

function PageToString()
{
	var temp = this.section + "," + this.topic + "," + this.subtopic + "," + this.page;
	return temp;
}

function getSubtopicHelper(subString)
{
	var code;
	subString = subString.toLowerCase();

	if (subString.length == 2)
	{
		code = getSubtopicHelper(subString.charAt(1));
		code += (((subString.charCodeAt(0) - 97) + 1)*26);
	}
	else
	{
		code = (subString.charCodeAt(0) - 97);
	}

	//alert("subTopic code for " + subString + " = " + code);
	return code;
}

// This function will compress a unicode string to
// 50% its original size.  This is possible only if
// the characters in the string to be compressed
// have ASCII values from 0 - 127.  If this is not so,
// then the string data will be corrupted.
function compressUnicodeString(dataString)
{
	var newString = "";

	if (dataString.length % 2 != 0)
	{
		dataString = dataString + " ";
	}
	for (var i=0;i<dataString.length;i+=2)
	{
		newString += String.fromCharCode(dataString.charCodeAt(i) | (dataString.charCodeAt(i+1) << 7));
	}
	
	return newString;
}

// Uncompresses a string that was compressed with the
// compressUnicodeString() function.
function uncompressUnicodeString(dataString)
{
	var newString = "";
	for (var i=0;i<dataString.length;i++)
	{
		newString += String.fromCharCode(dataString.charCodeAt(i) & 127) + String.fromCharCode((dataString.charCodeAt(i) & 16256)>>>7);
	}
	if (newString.charAt(newString.length-1) == " ")
	{
		newString = newString.slice(0,newString.length-1);
	}
	return newString;
}
